/* 
 * primes_joinable.c 
 *
 * Обчислює просте число з заданим номером (WHICH_PRIME).
 * Просте число обчислюється за допомогою придатного до приєднання потоку.
 * Результат виводить початковий потік.
 * Ілюструє порядок отримання результатів роботи (приєднаних) потоків.
 *
 */

#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Номер простого числа, яке треба знайти */
enum { WHICH_PRIME = 100 };

/* Глобальна змінна, через яку потік повертає результат */
unsigned long long prime;

void *compute_prime(void *arg);


/* Знаходить просте число з номером, переданим через аргумент. */
void *compute_prime(void *arg)
{
        unsigned long long cand = 2;
        unsigned int n = *((unsigned int *) arg);

        while (1) {
                int factor;
                int is_prime = 1;

                for (factor = 2; factor < cand; factor++) {
                        if (cand % factor == 0) {
                                is_prime = 0;
                                break;
                        }
                }
                if (is_prime && --n == 0) {
                        prime = cand;
                        /* Повертає результат. */
                        return (void*) &prime;
                }
                cand++;
        }
        return NULL;
}

int main()
{
        pthread_t thread;
        unsigned int which_prime = WHICH_PRIME;
        void *res;              /* Покажчик на результат роботи потоку */
        int terrno;

        /* Створює потік, що обчислює просте число з номером
           which_prime. */
        terrno = pthread_create(&thread, NULL, &compute_prime,
                                                        &which_prime);
        if (terrno != 0) {
                fprintf(stderr, "Error creating thread: %s\n",
                                                        strerror(terrno));
                exit(EXIT_FAILURE);
        }

        /* Чекає на завершення потоку. */
        terrno = pthread_join(thread, &res);
        if (terrno != 0) {
                fprintf(stderr, "Error joining thread: %s\n",
                                                        strerror(terrno));
                exit(EXIT_FAILURE);
        }

        /* Виводить результат. */
        printf("The %uth prime number is %llu.\n", which_prime,
                                        *((unsigned long long *) res));

        return EXIT_SUCCESS;
}
